#include "ados.h"
#include "standard.h"

/************************************************************************
 * NAME:	ados_putpsect()
 *
 * DESCR:	Write physical sector to floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:
 ************************************************************************/
int
ados_putpsect(struct adosfs *adosfs, int track, int sect, char buf[])
{
    return((*adosfs->pwritesec)(adosfs->device,0,track,sect+adosfs->startsec,buf));
}

/************************************************************************
 * NAME:	ados_getpsect()
 *
 * DESCR:	Read physical sector from floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:
 ************************************************************************/
int
ados_getpsect(struct adosfs *adosfs, int track, int sect, char buf[])
{
    return((adosfs->preadsec)(adosfs->device,0,track,sect+adosfs->startsec,buf));
}

